# MailForm.pl - library function for mailing form data
# Usage: MailForm(To, ReplyTo, Subject, Message, Mailer);
# where all parameters after To are optional.
# Note: Designed to be compatible with getFormData (in FormData.pl).
# Copyright (C) 1996 Stephen Lines <spraxlo@ai.mit.edu>

sub  mailForm {
  local($To, $ReplyTo, $Subject, $Message, $Mailer) = @_;
  local($key, $value);

  #open(STDERR,">>error.log");
  # Path of a mailer that sends formatted mail it reads from STDIN:
  # $Mailer = '/usr/local/sbin/exim -t';
$Mailer = '/usr/sbin/sendmail -t';

  # it now overrides $Mailer, period. ethan 01/15/02

  # For sendmail, -t means take the headers from the lines following
  # the initial command -- don't ever put a user-entered value for
  # the recipient in the command itself! The -oi options means don't
  # interpret a line begining with a period as ending the input.

  open (MAIL,"|$Mailer") ||
    die("$0: error opening mailer $Mailer: $!\n");

  print MAIL "To: ",    $To , "\n";
#  print MAIL "From: shambhala\@telusplanet.net \n";
  print MAIL "Reply-To: $ReplyTo\n"   if $ReplyTo;
  print MAIL "Subject:  $Subject\n\n" if $Subject;
  print MAIL $Message                 if $Message;
    
  print MAIL "\nMailData follows:\n";
  print MAIL "Server protocol: $ENV{'SERVER_PROTOCOL'}\n";
  print MAIL "Remote host name: $ENV{'REMOTE_HOST'}\n";
  print MAIL "Remote IP address: $ENV{'REMOTE_ADDR'}\n";
  close(MAIL);     # makes MailForm return 1 on success, 0 on error.
}

1; # return 1 to make "require 'MailForm.pl';" work.
